@extends('adminlte::page')

@section('title', 'Daftar Visitor')

@section('content_header')
    <h1>Daftar Visitor</h1>
@stop

@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="d-flex justify-content-between align-items-center mb-3">
    <a href="{{ route('visitor.create') }}" class="btn btn-success btn-sm">
        <i class="fas fa-plus"></i> Tambah Visitor
    </a>
    <form method="GET" action="{{ route('visitor.index') }}" class="d-flex" style="max-width:190px;">
        <div class="input-group input-group-sm">
            <input type="text" name="q" value="{{ request('q') }}" class="form-control" placeholder="Cari nama/kontak/alamat...">
            <button class="btn btn-primary btn-sm" type="submit">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </form>
</div>
<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Kunjungan Hari Ini</th>
            <th style="width:280px;">Aksi</th>
            <th>Hapus</th>
        </tr>
    </thead>
    <tbody>
        @forelse($visitors as $visitor)
        <tr>
            <td>{{ $visitor->nama }}</td>
            <td>{{ $visitor->kontak }}</td>
            <td>{{ $visitor->alamat }}</td>
            <td>
                {{ $visitor->attendances()->where('tanggal', date('Y-m-d'))->count() }} x
            </td>
            <td>
                <button class="btn btn-xs btn-info open-visit-modal"
                        data-toggle="modal"
                        data-target="#visitModal"
                        data-visitor-id="{{ $visitor->id }}"
                        data-visitor-nama="{{ $visitor->nama }}"
                        data-visit-only-price="{{ $visit_only_price ?? '' }}">
                    <i class="fas fa-calendar-check"></i> + Kunjungan
                </button>
                <a href="{{ route('visitor.to-member', $visitor->id) }}" class="btn btn-success btn-xs"><i class="fas fa-plus"></i> Member</a>
                <a href="{{ route('visitor.edit', $visitor->id) }}" class="btn btn-warning btn-xs">Edit</a>
            </td>
            <td>
                <form action="{{ route('visitor.destroy', $visitor->id) }}" method="POST" style="display:inline;">
                    @csrf @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-xs"
                        onclick="return confirm('Yakin hapus?')">Hapus</button>
                </form>
            </td>
        </tr>
        @empty
        <tr>
            <td colspan="6" class="text-center">Belum ada visitor.</td>
        </tr>
        @endforelse
    </tbody>
</table>

<div>
    {{ $visitors->links() }}
</div>

<!-- Modal statis -->
<div class="modal fade" id="visitModal" tabindex="-1" role="dialog" aria-labelledby="visitModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="visitModalLabel">Tambah Kunjungan: <span id="visitorName"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{-- Hidden input to store current visitor ID --}}
                <input type="hidden" id="currentVisitorId" value="">

                <div class="form-group">
                    <label>Pilih Tipe Kunjungan</label>
                    <select class="form-control tipe-kunjungan" id="tipe-kunjungan" onchange="showVisitFormDynamic()">
                        <option value="">-- Pilih --</option>
                        <option value="mandiri">Latihan Mandiri</option>
                        <option value="pt">Personal Trainer</option>
                    </select>
                </div>

                {{-- FORM LATIHAN MANDIRI --}}
                <form id="form-mandiri" method="POST" style="display:none;">
    @csrf
    <input type="hidden" name="visit_type" value="mandiri">
    <div class="form-group">
        <label>Harga Visit</label>
        <input type="text" class="form-control" name="harga_display" id="harga-visit-mandiri" readonly>
        <input type="hidden" name="harga" id="harga-visit-mandiri-hidden">
    </div>
    <div class="form-group">
        <label>Pembayaran</label>
        <input type="number" class="form-control bayar-input" name="bayar" id="bayar-mandiri" placeholder="Nominal bayar" required>
    </div>
    <div class="form-group">
        <label>Kembalian</label>
        <input type="text" class="form-control" id="kembalian-mandiri" readonly>
    </div>
    <div class="form-group">
        <label>Metode Pembayaran</label>
        <select class="form-control" name="payment_method" required>
            <option value="cash">Cash</option>
            <option value="debit">QRIS</option>
        </select>
    </div>
    <button type="submit" class="btn btn-success btn-block">Simpan & Cetak Nota</button>
</form>

                {{-- FORM PERSONAL TRAINER --}}
                <form id="form-pt" method="POST" style="display:none;">
                    @csrf
                    <input type="hidden" name="visit_type" value="pt">
                    <input type="hidden" name="buyer_type" value="visitor">
                    <input type="hidden" name="buyer_id" id="buyer-id-pt">
                    <div class="form-group">
                        <label>Pilih Produk PT</label>
                        <select class="form-control produk-pt" name="produk_id" id="produk-pt" required>
                            @foreach($pt_products as $product)
                                <option value="{{ $product->id }}" data-harga="{{ $product->harga }}">{{ $product->nama }} - Rp {{ number_format($product->harga,0,',','.') }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Pilih Instruktur</label>
                        <select class="form-control" name="instruktur_id" required>
                            @foreach($instructors as $ins)
                                <option value="{{ $ins->id }}">{{ $ins->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Harga</label>
                        <input type="text" name="harga" class="form-control" id="harga-pt" readonly>
                    </div>
                    <div class="form-group">
                        <label>Pembayaran</label>
                        <input type="number" class="form-control bayar-input" name="bayar" id="bayar-pt" placeholder="Nominal bayar" required>
                    </div>
                    <div class="form-group">
                        <label>Kembalian</label>
                        <input type="text" class="form-control" id="kembalian-pt" readonly>
                    </div>
                    <div class="form-group">
                        <label>Metode Pembayaran</label>
                        <select class="form-control" name="payment_method" required>
                            <option value="cash">Cash</option>
                            <option value="debit">QRIS</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success btn-block">Simpan & Cetak Nota</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
function formatRupiah(angka) {
    angka = angka || 0;
    return "Rp " + angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

function parseAngka(str) {
    // Pastikan hanya mengembalikan digit. Jika ada non-digit (selain koma atau titik jika ada desimal), dihapus.
    // Contoh: "Rp 100.000" -> "100000"
    return parseInt((str || "0").replace(/[^\d]/g, '')) || 0;
}

const VISIT_ONLY_PRICE = {{ $visit_only_price ?? 0 }};

function showVisitFormDynamic() {
    var tipe = $('#tipe-kunjungan').val();
    var visitorId = $('#currentVisitorId').val();

    $('#form-mandiri').hide();
    $('#form-pt').hide();

    if (tipe === 'mandiri') {
        $('#form-mandiri').show();
        // Simpan harga asli di hidden input, lalu tampilkan yang terformat
        $('#harga-visit-mandiri-hidden').val(VISIT_ONLY_PRICE); // Simpan angka asli
        $('#harga-visit-mandiri').val(formatRupiah(VISIT_ONLY_PRICE)); // Tampilkan yang terformat
        $('#bayar-mandiri').val('');
        $('#kembalian-mandiri').val(formatRupiah(0));
        $('#form-mandiri').attr('action', `/visitor_attendance/visit_mandiri/${visitorId}`);
    } else if (tipe === 'pt') {
        $('#form-pt').show();
        $('#bayar-pt').val('');
        $('#kembalian-pt').val(formatRupiah(0));
        $('#form-pt').attr('action', `/visitor_attendance/visit_pt/${visitorId}`);
        // Trigger perubahan untuk mengisi harga PT
        $('#produk-pt').trigger('change');
    }
}

$(document).on('click', '.open-visit-modal', function () {
    const visitorId = $(this).data('visitor-id');
    const visitorNama = $(this).data('visitor-nama');
    $('#currentVisitorId').val(visitorId);
    $('#visitorName').text(visitorNama);
    $('#tipe-kunjungan').val('');
    $('#form-mandiri').hide();
    $('#form-pt').hide();
});

// PT: Saat produk dipilih, update harga (otomatis format)
$(document).on('change', '#produk-pt', function(){
    var hargaAsli = $(this).find(':selected').data('harga') || 0;
    // Simpan harga asli (angka) di data attribute atau hidden input jika perlu
    // Untuk saat ini, kita akan langsung menggunakannya dalam perhitungan
    $('#harga-pt').val(formatRupiah(hargaAsli)); // Tampilkan harga terformat
    $('#harga-pt').data('raw-harga', hargaAsli); // Simpan nilai angka mentah di data attribute
    $('#bayar-pt').val('');
    $('#kembalian-pt').val(formatRupiah(0));
});

// PT: Hitung kembalian saat bayar diinput
$(document).on('input', '#bayar-pt', function(){
    var bayar = parseAngka($(this).val());
    // Ambil harga asli (angka mentah) dari data attribute
    var harga = $('#harga-pt').data('raw-harga') || 0; // Ambil nilai angka mentah
    var kembalian = bayar - harga;
    $('#kembalian-pt').val(formatRupiah(kembalian > 0 ? kembalian : 0));
});

// Mandiri: Hitung kembalian & format harga
$(document).on('input', '#bayar-mandiri', function(){
    var bayar = parseAngka($(this).val());
    // Ambil harga asli dari hidden input untuk mandiri
    var harga = parseAngka($('#harga-visit-mandiri-hidden').val()); // Menggunakan hidden input
    var kembalian = bayar - harga;
    $('#kembalian-mandiri').val(formatRupiah(kembalian > 0 ? kembalian : 0));
});


// Pastikan form tersembunyi di awal
$(document).ready(function() {
    $('#form-mandiri').hide();
    $('#form-pt').hide();
    $('#tipe-kunjungan').val('');
});
</script>
@endsection